/*
 * export_scheme_fields.sql 2020-2-14
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */
DROP TABLE IF EXISTS `export_scheme_fields`;
CREATE TABLE `export_scheme_fields` (
	`field_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
	`scheme_id` int(11) unsigned NOT NULL DEFAULT '0',
	`field_name` varchar(255) NOT NULL DEFAULT '',
	`field_content` varchar(255) NOT NULL DEFAULT '',
	`field_content_default` varchar(255) NOT NULL DEFAULT '',
	`created_by` varchar(45) NOT NULL DEFAULT 'custom',
	`sort_order` int(11) NOT NULL DEFAULT '0',
	`status` tinyint(1) NOT NULL DEFAULT '1',
	PRIMARY KEY (`field_id`),
	KEY `fk_export_scheme_fields_export_schemes_idx` (`scheme_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


INSERT INTO `export_scheme_fields` (`scheme_id`, `field_name`, `field_content`, `field_content_default`, `created_by`, `sort_order`, `status`) VALUES
	(1, 'ID', '{p_id}', '', 'gambio', 1, 1),
	(1, 'Titel', '{p_google_name_vpe_suffix|truncate:150:"..."}', '', 'gambio', 2, 1),
	(1, 'Beschreibung', '{p_description|truncate:5000:"..."}', '', 'gambio', 3, 1),
	(1, 'Google Produktkategorie', '{p_google_category|truncate:750:"..."}', '', 'gambio', 4, 1),
	(1, 'Produkttyp', '{c_path}', '', 'gambio', 5, 1),
	(1, 'Link', '{p_link}', '', 'gambio', 6, 1),
	(1, 'Bildlink', '{p_popup_image}', '', 'gambio', 7, 1),
	(1, 'Zusätzlicher Bildlink', '{p_popup_images}', '', 'gambio', 8, 1),
	(1, 'Zustand', '{p_google_export_condition}', '', 'gambio', 9, 1),
	(1, 'Verfügbarkeit', '{p_google_export_availability}', '', 'gambio', 10, 1),
	(1, 'Preis', '{p_google_price}', '', 'gambio', 11, 1),
	(1, 'Sonderangebotspreis', '{p_google_special_price}', '', 'gambio', 12, 1),
	(1, 'Sonderangebotszeitraum', '{p_special_period}', '', 'gambio', 13, 1),
	(1, 'Marke', '{brand_name|truncate:70:"..."}', '', 'gambio', 14, 1),
	(1, 'GTIN', '{p_google_export_gtin}', '', 'gambio', 15, 1),
	(1, 'MPN', '{code_mpn}', '', 'gambio', 16, 1),
	(1, 'Kennzeichnung existiert', '{p_google_identifier_exists}', '', 'gambio', 17, 1),
	(1, 'Geschlecht', '{gender}', '', 'gambio', 18, 1),
	(1, 'Altersgruppe', '{age_group}', '', 'gambio', 19, 1),
	(1, 'Versandgewicht', '{p_weight_gram} g', '', 'gambio', 20, 1),
	(1, 'Nicht jugendfrei', '{p_google_fsk18}', '', 'gambio', 21, 1),
	(1, 'Grundpreis Maß', '{p_google_unit_price_measure}', '', 'gambio', 22, 1),
	(1, 'Grundpreis Einheitsmaß', '{p_google_unit_pricing_base_measure}', '', 'gambio', 23, 1),
	(1, 'Verfallsdatum', '{p_expiration_date}', '', 'gambio', 24, 1),
	(1, 'Farbe', '{collective_field||Farbe||attributes;additional_fields}', '', 'gambio', 25, 1),
	(1, 'Größe', '{collective_field||Größe||attributes;additional_fields}', '', 'gambio', 26, 1),
	(1, 'Material', '{collective_field||Material||attributes;additional_fields}', '', 'gambio', 27, 1),
	(1, 'Muster', '{collective_field||Muster||attributes;additional_fields}', '', 'gambio', 28, 1),
	(1, 'Produktgruppe', '{p_google_product_group}', '', 'gambio', 29, 1),
	(2, 'aid', '{p_id}', '', 'gambio', 1, 1),
	(2, 'brand', '{p_manufacturer_name}', '', 'gambio', 2, 1),
	(2, 'mpnr', '{p_model}', '', 'gambio', 3, 1),
	(2, 'ean', '{p_ean}', '', 'gambio', 4, 1),
	(2, 'name', '{p_name}', '', 'gambio', 5, 1),
	(2, 'desc', '{p_description}', '', 'gambio', 6, 1),
	(2, 'shop_cat', '{c_path}', '', 'gambio', 7, 1),
	(2, 'price', '{p_price_point}', '', 'gambio', 8, 1),
	(2, 'ppu', '{p_baseprice_point}', '', 'gambio', 9, 1),
	(2, 'link', '{p_link}', '', 'gambio', 10, 1),
	(2, 'image', '{p_popup_image}', '', 'gambio', 11, 1),
	(2, 'dlv_time', '{p_shipping_status_name}', '', 'gambio', 12, 1),
	(2, 'dlv_cost', '{p_shipping_costs_point}', '0.00', 'gambio', 13, 1),
	(2, 'pzn', '', '', 'gambio', 14, 1),
	(3, 'Artikelnummer', '{p_id}', '', 'gambio', 1, 1),
	(3, 'EAN', '{p_ean}', '', 'gambio', 2, 1),
	(3, 'Herstellerartikelnummer', '{p_model}', '', 'gambio', 3, 1),
	(3, 'Herstellername', '{p_manufacturer_name}', '', 'gambio', 4, 1),
	(3, 'Produktname', '{p_name}', '', 'gambio', 5, 1),
	(3, 'Kategorie', '{c_path}', '', 'gambio', 6, 1),
	(3, 'Preis', '{p_price_point}', '', 'gambio', 7, 1),
	(3, 'Lieferzeit', '{p_shipping_status_name}', '', 'gambio', 8, 1),
	(3, 'ProduktURL', '{p_link}', '', 'gambio', 9, 1),
	(3, 'BildURL', '{p_popup_image}', '', 'gambio', 10, 1),
	(3, 'Versandkosten Vorkasse', '{p_shipping_costs_point}', '0.00', 'gambio', 11, 1),
	(3, 'Beschreibung', '{p_description}', '', 'gambio', 12, 1),
	(3, 'Grundpreis', '{p_baseprice_point}', '', 'gambio', 13, 1),
	(4, 'Artikel-Nr.', '{p_id}', '', 'gambio', 0, 1),
	(4, 'Artikelname', '{p_name}', '', 'gambio', 1, 1),
	(4, 'Preis', '{p_price_point}', '', 'gambio', 2, 1),
	(4, 'Deeplink', '{p_link}', '', 'gambio', 3, 1),
	(4, 'Bild-URL', '{p_popup_image}', '', 'gambio', 4, 1),
	(4, 'Kurzbeschr.', '{p_short_description}', '', 'gambio', 5, 1),
	(4, 'Versandk.', '{p_shipping_costs_point}', '0.00', 'gambio', 6, 1),
	(4, 'Verfügbarkeit', '{p_shipping_status_name}', '', 'gambio', 7, 1),
	(4, 'EAN', '{p_ean}', '', 'gambio', 8, 1),
	(4, 'PZN', '', '', 'gambio', 9, 1),
	(4, 'Hersteller', '{p_manufacturer_name}', '', 'gambio', 10, 1),
	(4, 'Hersteller-ArtNr', '{code_mpn}', '', 'gambio', 11, 1),
	(4, 'Kategorie', '{c_path}', '', 'gambio', 12, 1),
	(5, 'XTSOL', 'XTSOL', '', 'gambio', 0, 1),
	(5, 'p_id', '{products_id}', '', 'gambio', 1, 1),
	(5, 'p_model', '{products_model}', '', 'gambio', 2, 1),
	(5, 'p_stock', '{products_quantity}', '', 'gambio', 3, 1),
	(5, 'p_sorting', '{products_sort}', '', 'gambio', 4, 1),
	(5, 'p_startpage', '{products_startpage}', '', 'gambio', 5, 1),
	(5, 'p_startpage_sort', '{products_startpage_sort}', '', 'gambio', 6, 1),
	(5, 'p_shipping', '{products_shippingtime}', '', 'gambio', 7, 1),
	(5, 'p_tpl', '{product_template}', '', 'gambio', 8, 1),
	(5, 'p_opttpl', '{options_template}', '', 'gambio', 9, 1),
	(5, 'p_manufacturer', '{manufacturers_id}', '', 'gambio', 10, 1),
	(5, 'p_fsk18', '{products_fsk18}', '', 'gambio', 11, 1),
	(5, 'p_priceNoTax', '{products_price}', '', 'gambio', 12, 1),
	(5, 'p_priceNoTax.1', '{p_personal_offer#1}', '', 'gambio', 13, 1),
	(5, 'p_priceNoTax.2', '{p_personal_offer#2}', '', 'gambio', 14, 1),
	(5, 'p_priceNoTax.3', '{p_personal_offer#3}', '', 'gambio', 15, 1),
	(5, 'p_tax', '{products_tax_class_id}', '', 'gambio', 16, 1),
	(5, 'p_status', '{products_status}', '', 'gambio', 17, 1),
	(5, 'p_weight', '{products_weight}', '', 'gambio', 18, 1),
	(5, 'p_ean', '{products_ean}', '', 'gambio', 19, 1),
	(5, 'code_isbn', '{code_isbn}', '', 'gambio', 20, 1),
	(5, 'code_upc', '{code_upc}', '', 'gambio', 21, 1),
	(5, 'code_mpn', '{code_mpn}', '', 'gambio', 22, 1),
	(5, 'code_jan', '{code_jan}', '', 'gambio', 23, 1),
	(5, 'brand_name', '{brand_name}', '', 'gambio', 24, 1),
	(5, 'p_disc', '{products_discount_allowed}', '', 'gambio', 25, 1),
	(5, 'p_date_added', '{products_date_added}', '', 'gambio', 26, 1),
	(5, 'p_last_modified', '{products_last_modified}', '', 'gambio', 27, 1),
	(5, 'p_date_available', '{products_date_available}', '', 'gambio', 28, 1),
	(5, 'p_ordered', '{products_ordered}', '', 'gambio', 29, 1),
	(5, 'nc_ultra_shipping_costs', '{nc_ultra_shipping_costs}', '', 'gambio', 30, 1),
	(5, 'gm_show_date_added', '{gm_show_date_added}', '', 'gambio', 31, 1),
	(5, 'gm_show_price_offer', '{gm_show_price_offer}', '', 'gambio', 32, 1),
	(5, 'gm_show_weight', '{gm_show_weight}', '', 'gambio', 33, 1),
	(5, 'gm_show_qty_info', '{gm_show_qty_info}', '', 'gambio', 34, 1),
	(5, 'gm_price_status', '{gm_price_status}', '', 'gambio', 35, 1),
	(5, 'gm_min_order', '{gm_min_order}', '', 'gambio', 36, 1),
	(5, 'gm_graduated_qty', '{gm_graduated_qty}', '', 'gambio', 37, 1),
	(5, 'gm_options_template', '{gm_options_template}', '', 'gambio', 38, 1),
	(5, 'p_vpe', '{products_vpe}', '', 'gambio', 39, 1),
	(5, 'p_vpe_status', '{products_vpe_status}', '', 'gambio', 40, 1),
	(5, 'p_vpe_value', '{products_vpe_value}', '', 'gambio', 41, 1),
	(5, 'p_image.1', '{products_image#1}', '', 'gambio', 42, 1),
	(5, 'p_image.2', '{products_image#2}', '', 'gambio', 43, 1),
	(5, 'p_image.3', '{products_image#3}', '', 'gambio', 44, 1),
	(5, 'p_image', '{products_image}', '', 'gambio', 45, 1),
	(5, 'p_name.en', '{products_name.en}', '', 'gambio', 46, 1),
	(5, 'p_desc.en', '{products_description.en}', '', 'gambio', 47, 1),
	(5, 'p_shortdesc.en', '{products_short_description.en}', '', 'gambio', 48, 1),
	(5, 'p_checkout_information.en', '{checkout_information.en}', '', 'gambio', 49, 1),
	(5, 'p_meta_title.en', '{products_meta_title.en}', '', 'gambio', 50, 1),
	(5, 'p_meta_desc.en', '{products_meta_description.en}', '', 'gambio', 51, 1),
	(5, 'p_meta_key.en', '{products_meta_keywords.en}', '', 'gambio', 52, 1),
	(5, 'p_keywords.en', '{products_keywords.en}', '', 'gambio', 53, 1),
	(5, 'p_url.en', '{products_url.en}', '', 'gambio', 54, 1),
	(5, 'gm_url_keywords.en', '{gm_url_keywords.en}', '', 'gambio', 55, 1),
	(5, 'rewrite_url.en', '{rewrite_url.en}', '', 'gambio', 56, 1),
	(5, 'p_name.de', '{products_name.de}', '', 'gambio', 57, 1),
	(5, 'p_desc.de', '{products_description.de}', '', 'gambio', 58, 1),
	(5, 'p_shortdesc.de', '{products_short_description.de}', '', 'gambio', 59, 1),
	(5, 'p_checkout_information.de', '{checkout_information.de}', '', 'gambio', 60, 1),
	(5, 'p_meta_title.de', '{products_meta_title.de}', '', 'gambio', 61, 1),
	(5, 'p_meta_desc.de', '{products_meta_description.de}', '', 'gambio', 52, 1),
	(5, 'p_meta_key.de', '{products_meta_keywords.de}', '', 'gambio', 63, 1),
	(5, 'p_keywords.de', '{products_keywords.de}', '', 'gambio', 64, 1),
	(5, 'p_url.de', '{products_url.de}', '', 'gambio', 65, 1),
	(5, 'gm_url_keywords.de', '{gm_url_keywords.de}', '', 'gambio', 66, 1),
	(5, 'rewrite_url.de', '{rewrite_url.de}', '', 'gambio', 67, 1),
	(5, 'p_cat.en', '{c_path.en}', '', 'gambio', 68, 1),
	(5, 'p_cat.de', '{c_path.de}', '', 'gambio', 69, 1),
	(5, 'google_export_availability', '{p_google_export_availability}', '', 'gambio', 70, 1),
	(5, 'google_export_condition', '{p_google_export_condition}', '', 'gambio', 71, 1),
	(5, 'google_category', '{p_google_category}', '', 'gambio', 72, 1),
	(5, 'p_img_alt_text.en', '{p_gm_alt_text.en}', '', 'gambio', 73, 1),
	(5, 'p_img_alt_text.1.en', '{p_gm_alt_text#1.en}', '', 'gambio', 74, 1),
	(5, 'p_img_alt_text.2.en', '{p_gm_alt_text#2.en}', '', 'gambio', 75, 1),
	(5, 'p_img_alt_text.3.en', '{p_gm_alt_text#3.en}', '', 'gambio', 76, 1),
	(5, 'p_img_alt_text.de', '{p_gm_alt_text.de}', '', 'gambio', 77, 1),
	(5, 'p_img_alt_text.1.de', '{p_gm_alt_text#1.de}', '', 'gambio', 78, 1),
	(5, 'p_img_alt_text.2.de', '{p_gm_alt_text#2.de}', '', 'gambio', 79, 1),
	(5, 'p_img_alt_text.3.de', '{p_gm_alt_text#3.de}', '', 'gambio', 80, 1),
	(5, 'p_group_permission.0', '{p_group_permission#0}', '', 'gambio', 81, 1),
	(5, 'p_group_permission.1', '{p_group_permission#1}', '', 'gambio', 82, 1),
	(5, 'p_group_permission.2', '{p_group_permission#2}', '', 'gambio', 83, 1),
	(5, 'p_group_permission.3', '{p_group_permission#3}', '', 'gambio', 84, 1),
	(5, 'specials_qty', '{specials_quantity}', '', 'gambio', 85, 1),
	(5, 'specials_new_products_price', '{specials_new_products_price}', '', 'gambio', 86, 1),
	(5, 'expires_date', '{expires_date}', '', 'gambio', 87, 1),
	(5, 'specials_status', '{status}', '', 'gambio', 88, 1),
	(5, 'gm_priority', '{gm_priority}', '', 'gambio', 89, 1),
	(5, 'gm_changefreq', '{gm_changefreq}', '', 'gambio', 90, 1),
	(5, 'gm_sitemap_entry', '{gm_sitemap_entry}', '', 'gambio', 91, 1),
	(5, 'p_qty_unit_id', '{quantity_unit_id}', '', 'gambio', 92, 1),
	(5, 'p_type', '{product_type}', '', 'gambio', 93, 1),
	(6, 'Description', '{p_description}', '', 'gambio', 11, 1),
	(6, 'Brand', '{p_manufacturer_name}', '', 'gambio', 10, 1),
	(6, 'MPN', '{code_mpn}', '', 'gambio', 9, 1),
	(6, 'EAN', '{p_ean}', '', 'gambio', 8, 1),
	(6, 'Image URL', '{p_popup_image}', '', 'gambio', 7, 1),
	(6, 'Category', '{c_path}', '', 'gambio', 6, 1),
	(6, 'Shipping Cost', '{p_shipping_costs_comma}', '0,00', 'gambio', 5, 1),
	(6, 'Offer ID', '{p_id}', '', 'gambio', 4, 1),
	(6, 'Price', '{p_price_comma}', '', 'gambio', 3, 1),
	(6, 'Product URL', '{p_link}', '', 'gambio', 2, 1),
	(6, 'Product Name', '{p_name}', '', 'gambio', 1, 1),
	(6, 'OfferValidity', '', '', 'gambio', 12, 1),
	(6, 'Availability', '{p_shipping_status_name}', '', 'gambio', 13, 1),
	(7, 'product_url', '{p_link}', '', 'gambio', 10, 1),
	(7, 'weight', '{products_weight}', '', 'gambio', 9, 1),
	(7, 'shippingtime', '{p_shipping_status_name}', '', 'gambio', 8, 1),
	(7, 'quantity', '{p_quantity}', '', 'gambio', 6, 1),
	(7, 'price', '{p_price_comma}', '', 'gambio', 5, 1),
	(7, 'name', '{p_name}', '', 'gambio', 4, 1),
	(7, 'brand', '{p_manufacturer_name}', '', 'gambio', 3, 1),
	(7, 'ean', '{p_ean}', '', 'gambio', 2, 1),
	(7, 'id', '{p_id}', '', 'gambio', 1, 1),
	(7, 'shippingstatus', '{number_of_days}', '', 'gambio', 7, 1),
	(7, 'image_url', '{p_popup_image}', '', 'gambio', 11, 1),
	(7, 'description', '{p_description}', '', 'gambio', 12, 1),
	(8, 'ProduktID', '{p_id}', '', 'gambio', 1, 1),
	(8, 'Gewicht', '{products_weight}', '', 'gambio', 2, 1),
	(8, 'EAN', '{p_ean}', '', 'gambio', 3, 1),
	(8, 'Hersteller', '{p_manufacturer_name}', '', 'gambio', 4, 1),
	(8, 'ProduktBezeichnung', '{p_name}', '', 'gambio', 5, 1),
	(8, 'ArtikelNroderHerstellerArtikelNr', '{p_model}', '', 'gambio', 6, 1),
	(8, 'Preis', '{p_price_comma}', '', 'gambio', 7, 1),
	(8, 'ProduktLangBeschreibung', '{p_description}', '', 'gambio', 8, 1),
	(8, 'ProduktKurzBeschreibung', '{p_short_description}', '', 'gambio', 9, 1),
	(8, 'Lieferzeit', '{p_shipping_status_name}', '', 'gambio', 10, 1),
	(8, 'Versandkosten', '{p_shipping_costs_comma}', '0,00', 'gambio', 11, 1),
	(8, 'Produktlink', '{p_link}', '', 'gambio', 12, 1),
	(8, 'FotoLink', '{p_popup_image}', '', 'gambio', 13, 1),
	(8, 'Kategoriename', '{c_path}', '', 'gambio', 14, 1),
	(9, 'offer-id', '{p_id}', '', 'gambio', 1, 1),
	(9, 'label', '{p_name}', '', 'gambio', 2, 1),
	(9, 'merchant-category', '{c_path}', '', 'gambio', 3, 1),
	(9, 'prices', '{p_price_point}', '', 'gambio', 4, 1),
	(9, 'offer-url', '{p_link}', '', 'gambio', 5, 1),
	(9, 'brand', '{p_manufacturer_name}', '', 'gambio', 6, 1),
	(9, 'description', '{p_short_description}', '', 'gambio', 7, 1),
	(9, 'image-url', '{p_popup_image}', '', 'gambio', 8, 1),
	(9, 'old-prices', '{p_old_price_point_currency}', '', 'gambio', 9, 1),
	(9, 'mfname', '', '', 'gambio', 10, 1),
	(9, 'mfpn', '', '', 'gambio', 11, 1),
	(9, 'product-id', '{p_model}', '', 'gambio', 12, 1),
	(9, 'delivery-period', '{p_shipping_status_name}', '', 'gambio', 13, 1),
	(9, 'delivery_period_text', '', '', 'gambio', 14, 1),
	(9, 'delivery-charge', '{p_shipping_costs_point}', '0.00', 'gambio', 15, 1),
	(9, 'delivery_charge_text', '', '', 'gambio', 16, 1),
	(9, 'baseprice-unit', '{become_baseprice_unit}', '', 'gambio', 17, 1),
	(9, 'baseprice-value', '{become_baseprice_value}', '', 'gambio', 18, 1),
	(9, 'baseprice-amount', '{become_baseprice_amount}', '', 'gambio', 19, 1),
	(10, 'ProduktID', '{p_id}', '', 'gambio', 1, 1),
	(10, 'Gewicht', '{products_weight}', '', 'gambio', 2, 1),
	(10, 'EAN', '{p_ean}', '', 'gambio', 3, 1),
	(10, 'Lagerbestand', '{p_quantity_floor}', '', 'gambio', 4, 1),
	(10, 'Hersteller', '{p_manufacturer_name}', '', 'gambio', 5, 1),
	(10, 'ProduktBezeichnung', '{p_name}', '', 'gambio', 6, 1),
	(10, 'ArtikelNroderHerstellerArtikelNr', '{p_model}', '', 'gambio', 7, 1),
	(10, 'Preis', '{p_price_comma}', '', 'gambio', 8, 1),
	(10, 'ProduktLangBeschreibung', '{p_description}', '', 'gambio', 9, 1),
	(10, 'ProduktKurzBeschreibung', '{p_short_description}', '', 'gambio', 10, 1),
	(10, 'Lieferzeit', '{p_shipping_status_name}', '', 'gambio', 11, 1),
	(10, 'Produktlink', '{p_link}', '', 'gambio', 12, 1),
	(10, 'FotoLink', '{p_popup_image}', '', 'gambio', 13, 1),
	(10, 'Kategoriename', '{c_name}', '', 'gambio', 14, 1),
	(10, 'Grundpreis', '{p_baseprice_point}', '', 'gambio', 15, 1);

INSERT INTO `export_scheme_fields` (`scheme_id`, `field_name`, `field_content`, `field_content_default`, `created_by`, `sort_order`, `status`) VALUES
	(11, 'Lieferzeit', '{p_shipping_status_name}', '', 'gambio', 22, 1),
	(11, 'TecDoc Daten', '0', '', 'gambio', 21, 1),
	(11, 'Gewicht', '{p_weight_comma}', '', 'gambio', 20, 1),
	(11, 'Versandkosten PP', '', '', 'gambio', 19, 1),
	(11, 'Versandkosten KK', '', '', 'gambio', 18, 1),
	(11, 'Versandkosten VK', '{p_shipping_costs_comma}', '0,00', 'gambio', 16, 1),
	(11, 'Versandkosten NN', '', '', 'gambio', 17, 1),
	(11, 'Angebotsformat', '1', '', 'gambio', 15, 1),
	(11, 'Im Austausch', '1', '', 'gambio', 14, 1),
	(11, 'Zustand', '1', '', 'gambio', 13, 1),
	(11, 'Produktbeschreibung', '{p_description}', '', 'gambio', 11, 1),
	(11, 'ProduktURL', '{p_link}', '', 'gambio', 12, 1),
	(11, 'BildURL(groß)', '{p_popup_image}', '', 'gambio', 10, 1),
	(11, 'Kategorie', '{c_name}', '', 'gambio', 9, 1),
	(11, 'Preis', '{p_price_comma}', '', 'gambio', 8, 1),
	(11, 'Kompatibilität', '{products_ean}', '', 'gambio', 7, 1),
	(11, 'Produktname', '{p_name}', '', 'gambio', 6, 1),
	(11, 'OE-Vergleichsnummern', '', '', 'gambio', 5, 1),
	(11, 'EAN-Nummer', '{products_ean}', '', 'gambio', 4, 1),
	(11, 'Teilenummer', '{p_model}', '', 'gambio', 3, 1),
	(11, 'Hersteller', '{p_manufacturer_name}', '', 'gambio', 2, 1),
	(11, 'Artikelnummer', '{p_id}', '', 'gambio', 1, 1),
	(12, 'Manufacturer with Manufacturer Part # (SKU)', '{p_manufacturer_name} {code_mpn}', '', 'gambio', 1, 1),
	(12, 'UPC', '{p_ean}', '', 'gambio', 2, 1),
	(12, 'ISBN', '{code_isbn}', '', 'gambio', 3, 1),
	(12, 'Product Name', '{p_name}', '', 'gambio', 4, 1),
	(12, 'Description', '{p_description}', '', 'gambio', 5, 1),
	(12, 'Price', '{p_price_comma}', '', 'gambio', 6, 1),
	(12, 'Click-out-URL', '{p_link}', '', 'gambio', 7, 1),
	(12, 'Category', '{c_path}', '', 'gambio', 8, 1),
	(12, 'Product Condition', '{p_google_export_condition}', '', 'gambio', 11, 1),
	(12, 'Stock Status', '{p_quantity_floor}', '', 'gambio', 10, 1),
	(12, 'Image URL', '{p_popup_image}', '', 'gambio', 9, 1),
	(12, 'Ground Shipping', '{p_shipping_costs_comma}', '0.00', 'gambio', 12, 1),
	(12, 'Cost-per-Click', '', '', 'gambio', 13, 1),
	(13, 'ART_NUMBER', '{p_id}', '', 'gambio', 1, 1),
	(13, 'ART_NAME', '{p_name}', '', 'gambio', 2, 1),
	(13, 'DEEP_LINK', '{p_link}', '', 'gambio', 3, 1),
	(13, 'LONG_DESCRIPTION', '{p_description}', '', 'gambio', 4, 1),
	(13, 'IMAGE_URL', '{p_popup_image}', '', 'gambio', 5, 1),
	(13, 'CATEGORY', '{c_path}', '', 'gambio', 6, 1),
	(13, 'PRICE', '{p_price_comma}', '', 'gambio', 7, 1),
	(13, 'EAN', '{p_ean}', '', 'gambio', 8, 1),
	(13, 'DELIVERY_TIME', '{p_shipping_status_name}', '', 'gambio', 9, 1),
	(13, 'DELIVERY_COSTS', '{p_shipping_costs_comma}', '0,00', 'gambio', 10, 1),
	(13, 'OLD_PRICE', '{p_old_price_comma}', '', 'gambio', 11, 1),
	(13, 'KEYWORDS', '{products_meta_keywords}', '', 'gambio', 12, 1),
	(13, 'AVAILABLE_PRODUCTS', '{p_quantity}', '', 'gambio', 13, 1),
	(13, 'BRAND', '{p_manufacturer_name}', '', 'gambio', 14, 1),
	(14, 'Artikelnummer', '{p_id}', '', 'gambio', 1, 1),
	(14, 'Produktbezeichnung (inkl. Hersteller)', '{p_name}', '', 'gambio', 2, 1),
	(14, 'Produktbeschreibung', '{p_description}', '', 'gambio', 3, 1),
	(14, 'Preis', '{p_price_comma}', '', 'gambio', 4, 1),
	(14, 'Status Lieferbarkeit', '{p_shipping_status_name}', '', 'gambio', 5, 1),
	(14, 'Deeplink zum Artikel', '{p_link}', '', 'gambio', 6, 1),
	(14, 'Deeplink zum Artikelfoto', '{p_popup_image}', '', 'gambio', 7, 1),
	(14, 'EAN', '{p_ean}', '', 'gambio', 8, 1),
	(14, 'produktbezogene Versandkosten', '{p_shipping_costs_point}', '0.00', 'gambio', 9, 1),
	(15, 'category', '{c_path}', '', 'gambio', 1, 1),
	(15, 'offer_id', '{p_id}', '', 'gambio', 2, 1),
	(15, 'name', '{p_name}', '', 'gambio', 3, 1),
	(15, 'price', '{p_price_point}', '', 'gambio', 4, 1),
	(15, 'product_url', '{p_link}', '', 'gambio', 5, 1),
	(15, 'image_url', '{p_popup_image}', '', 'gambio', 6, 1),
	(15, 'description', '{p_description}', '', 'gambio', 7, 1),
	(15, 'shipping', '{p_shipping_costs_point}', '0.00', 'gambio', 8, 1),
	(15, 'availability', '0', '', 'gambio', 9, 1),
	(15, 'brand', '{p_manufacturer_name}', '', 'gambio', 10, 1),
	(15, 'ean', '{p_ean}', '', 'gambio', 11, 1),
	(15, 'list_price', '{p_old_price_point}', '', 'gambio', 12, 1),
	(15, 'model_number', '{p_model}', '', 'gambio', 13, 1),
	(16, 'productid', '{p_id}', '', 'gambio', 1, 1),
	(16, 'name', '{p_name}', '', 'gambio', 2, 1),
	(16, 'price', '{p_price_point}', '', 'gambio', 3, 1),
	(16, 'description_short', '{p_short_description}', '', 'gambio', 4, 1),
	(16, 'description', '{p_description}', '', 'gambio', 5, 1),
	(16, 'deeplink', '{p_link}', '', 'gambio', 6, 1),
	(16, 'image', '{p_popup_image}', '', 'gambio', 7, 1),
	(16, 'deliverypossibilities', '{p_availability}', '', 'gambio', 8, 1),
	(16, 'deliverytime', '{p_shipping_status_name}', '', 'gambio', 9, 1),
	(16, 'deliverycost', '{p_shipping_costs_point}', '0.00', 'gambio', 10, 1),
	(16, 'categoryname', '{c_name}', '', 'gambio', 11, 1),
	(16, 'manufacturer', '{p_manufacturer_name}', '', 'gambio', 12, 1),
	(16, 'manufacturerid', '{p_model}', '', 'gambio', 13, 1),
	(16, 'ean', '{products_ean}', '', 'gambio', 14, 1),
	(17, 'Titel', '{p_name}', '', 'gambio', 1, 1),
	(17, 'Beschreibung', '{p_description}', '', 'gambio', 2, 1),
	(17, 'Kategorie in Pfadnavigation', '{c_path}', '', 'gambio', 3, 1),
	(17, 'Preis', '{p_price_comma}', '', 'gambio', 4, 1),
	(17, 'Produkt URL', '{p_link}', '', 'gambio', 5, 1),
	(17, 'Bild URL', '{p_popup_image}', '', 'gambio', 6, 1),
	(17, 'Page_ID', '{p_id}', '', 'gambio', 7, 1),
	(17, 'Lagerbestand', 'Auf Lager', '', 'gambio', 8, 1),
	(17, 'SKU / MPID', '{p_id}', '', 'gambio', 9, 1),
	(17, 'Hersteller / Marke', '{p_manufacturer_name}', '', 'gambio', 10, 1),
	(17, 'EAN/UPC', '{p_ean}', '', 'gambio', 11, 1),
	(17, 'ISBN', '{code_isbn}', '', 'gambio', 12, 1),
	(17, 'Zustand', 'Neu', '', 'gambio', 13, 1),
	(17, 'Versandkosten', '{p_shipping_costs_comma}', '0,00', 'gambio', 14, 1),
	(17, 'Bid', '', '', 'gambio', 15, 1),
	(17, 'Werbeaktion', '', '', 'gambio', 16, 1),
	(17, 'page_id_variant', '', '', 'gambio', 17, 1),
	(17, 'Empfohlener Verkaufspreis', '{p_old_price_comma}', '', 'gambio', 18, 1),
	(18, 'ID_VK', '{p_id}', '', 'gambio', 1, 1),
	(18, 'KLASSE', '', '', 'gambio', 2, 1),
	(18, 'STATUS', '1', '', 'gambio', 3, 1),
	(18, 'BEZEICHNUNG', '{products_name}', '', 'gambio', 4, 1),
	(18, 'DEF_1', '{p_manufacturer_name}', '', 'gambio', 5, 1),
	(18, 'DEF_2', '{p_model}', '', 'gambio', 6, 1),
	(18, 'KENZ_ID', '{p_ean}', '', 'gambio', 7, 1),
	(18, 'BESCHR_LANG', '{p_description}', '', 'gambio', 8, 1),
	(18, 'BESCHR_KURZ', '{p_short_description}', '', 'gambio', 9, 1),
	(18, 'ANG_MENGE', '{p_quantity}', '', 'gambio', 10, 1),
	(18, 'MENGEN_EINHEIT', '{vpe_name}', '', 'gambio', 11, 1),
	(18, 'ENTH_EINHEIT', '', '', 'gambio', 12, 1),
	(18, 'MIND_BEST_MENGE', '{gm_min_order}', '', 'gambio', 13, 1),
	(18, 'GRUNDP_INHALT', '', '', 'gambio', 14, 1),
	(18, 'GRUNDP_EINHEIT', '{vpe_name}', '', 'gambio', 15, 1),
	(18, 'GRUNDP_REFMENGE', '', '', 'gambio', 16, 1),
	(18, 'BILD_1', '{p_image}', '', 'gambio', 17, 1),
	(18, 'BILD_2', '{p_image#1}', '', 'gambio', 18, 1),
	(18, 'BILD_3', '{p_image#2}', '', 'gambio', 19, 1),
	(18, 'BILD_4', '{p_image#3}', '', 'gambio', 20, 1),
	(18, 'BILD_5', '{p_image#4}', '', 'gambio', 21, 1),
	(18, 'KEYWORDS', '{products_keywords}', '', 'gambio', 22, 1),
	(18, 'CROSS_SELLING', '', '', 'gambio', 23, 1),
	(18, 'PREIS', '{p_price_comma}', '', 'gambio', 24, 1),
	(18, 'MWST', '{p_tax}', '', 'gambio', 25, 1),
	(18, 'VERS_ZEIT', '{number_of_days}', '', 'gambio', 26, 1),
	(18, 'VERS_EINHEITEN', '{p_weight_point}', '', 'gambio', 27, 1),
	(18, 'VERS_GRUPPE', '', '', 'gambio', 28, 1),
	(18, 'VERS_AUFSCHL', '', '', 'gambio', 29, 1),
	(18, 'VERS_AUFSCHL_BER', '', '', 'gambio', 30, 1),
	(18, 'KAT_BAUM_VK', '{c_path.de}', '', 'gambio', 31, 1),
	(18, 'VAR_GRUPPE', '{products_id}', '', 'gambio', 32, 1),
	(18, 'VAR_ATTRIBUTE', '{p_attribute}', '', 'gambio', 33, 1),
	(19, 'Artikelnummer', '{p_id}', '', 'gambio', 1, 1),
	(19, 'Kategorie', '{c_name}', '', 'gambio', 2, 1),
	(19, 'Hersteller', '{p_manufacturer_name}', '', 'gambio', 3, 1),
	(19, 'Produktname', '{p_name}', '', 'gambio', 4, 1),
	(19, 'Deeplink', '{p_link}', '', 'gambio', 5, 1),
	(19, 'Bildlink', '{p_popup_image}', '', 'gambio', 6, 1),
	(19, 'EAN', '{p_ean}', '', 'gambio', 7, 1),
	(19, 'Herst-Art.Nr.', '{p_model}', '', 'gambio', 8, 1),
	(19, 'Preis', '{p_price_point}', '', 'gambio', 9, 1),
	(19, 'Versandkosten VK', '{p_shipping_costs_point}', '0.00', 'gambio', 10, 1),
	(19, 'Versandkosten NN', '0.00', '', 'gambio', 11, 1),
	(19, 'Lieferzeit', '{p_shipping_status_name}', '', 'gambio', 12, 1),
	(20, 'Artikelbezeichnung', '{p_name}', '', 'gambio', 1, 1),
	(20, 'Teilehersteller,Teilenummer', '{p_manufacturer_name},{p_model}', '', 'gambio', 2, 1),
	(20, 'Vergleichs-Teilehersteller,Vergleichs-Teilenummern', '', '', 'gambio', 3, 1),
	(20, 'Verwendung', '{p_ean}', '', 'gambio', 4, 1),
	(20, 'Preis', '{p_price_comma}', '', 'gambio', 5, 1),
	(20, 'Baugruppen- bzw. Kategorienummer', '', '', 'gambio', 6, 1),
	(20, 'Artikel-Nummer im Shop des Anbieters', '{p_id}', '', 'gambio', 7, 1),
	(20, 'Artikelfoto', '{p_popup_image}', '', 'gambio', 8, 1),
	(20, 'Artikelbeschreibung', '{p_description}', '', 'gambio', 9, 1),
	(20, 'Link zum Shop', '{p_link}', '', 'gambio', 10, 1),
	(20, 'Zustand', '1', '', 'gambio', 11, 1),
	(20, 'Pfand', '', '', 'gambio', 12, 1),
	(20, 'nicht genutzt M', '', '', 'gambio', 13, 1),
	(20, 'Versandkosten des Artikels', '{p_shipping_costs_comma}', '0,00', 'gambio', 14, 1),
	(20, 'Gewicht', '{p_weight_comma}', '', 'gambio', 15, 1),
	(20, 'nicht genutzt P', '', '', 'gambio', 16, 1),
	(20, 'Lieferzeit', '{p_daparto_shippingtime}', '', 'gambio', 17, 1),
	(21, 'Produktname', '{p_name}', '', 'gambio', 1, 1),
	(21, 'Produktbeschreibung', '{p_description}', '', 'gambio', 2, 1),
	(21, 'Preis', '{p_price_comma}', '', 'gambio', 3, 1),
	(21, 'Streichpreis', '{p_old_price_comma}', '', 'gambio', 4, 1),
	(21, 'Produkt-URL', '{p_link}', '', 'gambio', 5, 1),
	(21, 'Bild-URL', '{p_popup_image}', '', 'gambio', 6, 1),
	(21, 'Versandkosten', '{p_shipping_costs_comma}', '0,00', 'gambio', 7, 1),
	(21, 'Artikelnummer(SKU)', '{p_id}', '', 'gambio', 8, 1),
	(21, 'Kategoriename und Unterkategoriename', '{c_path}', '', 'gambio', 9, 1),
	(21, 'Unterstes Kategorielevel', '{c_name}', '', 'gambio', 10, 1),
	(21, 'Marke/Hersteller', '{p_manufacturer_name}', '', 'gambio', 11, 1),
	(21, 'EAN', '{p_ean}', '', 'gambio', 12, 1),
	(21, 'MPN', '{p_model}', '', 'gambio', 13, 1),
	(21, 'Verfügbarkeit', '{p_availability}', '', 'gambio', 14, 1),
	(21, 'Verfügbarkeitsdetails', '{p_shipping_status_name}', '', 'gambio', 15, 1),
	(21, 'Produkttyp', '', '', 'gambio', 16, 1),
	(21, 'Geschlecht', '', '', 'gambio', 17, 1),
	(21, 'Farbe', '', '', 'gambio', 18, 1),
	(21, 'Material', '', '', 'gambio', 19, 1),
	(21, 'Alternative Bild-URL 2', '{p_image#1}', '', 'gambio', 20, 1),
	(21, 'Alternative Bild-URL 3', '{p_image#2}', '', 'gambio', 21, 1),
	(21, 'Alternative Bild-URL 4', '{p_image#3}', '', 'gambio', 22, 1),
	(21, 'Alternative Bild-URL 5', '{p_image#4}', '', 'gambio', 23, 1),
	(21, 'Coupon-Code', '', '', 'gambio', 24, 1),
	(21, 'Coupon-Code Beschreibung', '', '', 'gambio', 25, 1),
	(21, 'Produkteigenschaften 1. Aufzählungspunkt', '', '', 'gambio', 26, 1),
	(21, 'Produkteigenschaften 2. Aufzählungspunkt', '', '', 'gambio', 27, 1),
	(21, 'Produkteigenschaften 3. Aufzählungspunkt', '', '', 'gambio', 28, 1),
	(21, 'Produkteigenschaften 4. Aufzählungspunkt', '', '', 'gambio', 29, 1),
	(21, 'Produkteigenschaften 5. Aufzählungspunkt', '', '', 'gambio', 30, 1),
	(21, 'Mobiltelefon', '', '', 'gambio', 31, 1),
	(21, 'Mobiltelefon Bauart', '', '', 'gambio', 32, 1),
	(21, 'Vertragstyp', '', '', 'gambio', 33, 1),
	(21, 'Mobilfunk-Nutzungsprofil', '', '', 'gambio', 34, 1),
	(22, 'ID', '{p_id}', '', 'gambio', 1, 1),
	(22, 'Titel', '{p_google_name_vpe_suffix|truncate:150:"..."}', '', 'gambio', 2, 1),
	(22, 'Beschreibung', '{p_description|truncate:5000:"..."}', '', 'gambio', 3, 1),
	(22, 'Google Produktkategorie', '{p_google_category|truncate:750:"..."}', '', 'gambio', 4, 1),
	(22, 'Produkttyp', '{c_path}', '', 'gambio', 5, 1),
	(22, 'Link', '{p_link}', '', 'gambio', 6, 1),
	(22, 'Bildlink', '{p_popup_image}', '', 'gambio', 7, 1),
	(22, 'Zusätzlicher Bildlink', '{p_popup_images}', '', 'gambio', 8, 1),
	(22, 'Zustand', '{p_google_export_condition}', '', 'gambio', 9, 1),
	(22, 'Verfügbarkeit', '{p_google_export_availability}', '', 'gambio', 10, 1),
	(22, 'Preis', '{p_google_price}', '', 'gambio', 11, 1),
	(22, 'Sonderangebotspreis', '{p_google_special_price}', '', 'gambio', 12, 1),
	(22, 'Sonderangebotszeitraum', '{p_special_period}', '', 'gambio', 13, 1),
	(22, 'Marke', '{brand_name|truncate:70:"..."}', '', 'gambio', 14, 1),
	(22, 'GTIN', '{p_google_export_gtin}', '', 'gambio', 15, 1),
	(22, 'MPN', '{code_mpn}', '', 'gambio', 16, 1),
	(22, 'Kennzeichnung existiert', '{p_google_identifier_exists}', '', 'gambio', 17, 1),
	(22, 'Geschlecht', '{gender}', '', 'gambio', 18, 1),
	(22, 'Altersgruppe', '{age_group}', '', 'gambio', 19, 1),
	(22, 'Versandgewicht', '{p_weight_gram} g', '', 'gambio', 20, 1),
	(22, 'Nicht jugendfrei', '{p_google_fsk18}', '', 'gambio', 21, 1),
	(22, 'Grundpreis Maß', '{p_google_unit_price_measure}', '', 'gambio', 22, 1),
	(22, 'Grundpreis Einheitsmaß', '{p_google_unit_pricing_base_measure}', '', 'gambio', 23, 1),
	(22, 'Verfallsdatum', '{p_expiration_date}', '', 'gambio', 24, 1),
	(22, 'Farbe', '{collective_field||Farbe||attributes;additional_fields}', '', 'gambio', 25, 1),
	(22, 'Größe', '{collective_field||Größe||attributes;additional_fields}', '', 'gambio', 26, 1),
	(22, 'Material', '{collective_field||Material||attributes;additional_fields}', '', 'gambio', 27, 1),
	(22, 'Muster', '{collective_field||Muster||attributes;additional_fields}', '', 'gambio', 28, 1);

INSERT INTO `export_scheme_fields` (`scheme_id`, `field_name`, `field_content`, `field_content_default`, `created_by`, `sort_order`, `status`) VALUES
	(22, 'Produktgruppe', '{p_google_product_group}', '', 'gambio', 29, 1),
    (5, 'p_property_image_list_id', '{p_property_image_list_id}', '', 'gambio', 94, 1);

INSERT INTO `export_scheme_fields` (`scheme_id`, `field_name`, `field_content`, `field_content_default`, `created_by`, `sort_order`, `status`) VALUES
	(23, 'product_id', '{p_id}', '', 'gambio', 1, 1),
	(23, 'title', '{products_name}', '', 'gambio', 2, 1),
	(23, 'description', '{p_description}', '', 'gambio', 3, 1),
	(23, 'price', '{p_price_point}', '', 'gambio', 4, 1),
	(23, 'currency', '{p_currency}', '', 'gambio', 5, 1),
	(23, 'update_date', '{products_last_modified}', '', 'gambio', 6, 1),
	(23, 'external_link', '{p_link}', '', 'gambio', 7, 1),
	(23, 'main_picture', '{p_popup_image}', '', 'gambio', 8, 1),
	(23, 'gallery_images', '{p_popup_images}', '', 'gambio', 9, 1),
	(23, 'category', '{c_path}', '', 'gambio', 10, 1);
